"""
Jeu du Tic Tac Toe/Moprion par Romain Schneider - Mis a disposition selon les termes de la licence Creative Commons (CC BY-NC-SA 4.0) - 2022. Source : https://projects.schneiderus.org/TicTacToe
Jeu realise en tant que projet de fin dannee de classe de NSI de Premiere.
Les fonctions ou des tests sont pertinants ont une fonction de test qui verifie leur bon fonctionnement. Les fonctions de test ont comme nom f_test_<fonction testee>, sauf pour f_test_init() qui sert a modifier tab_game. multi_test() est la fonction qui lance toutes les fonctions de test.
Pour jouer, exectuer le script entier, ou lancer la fonction menu() dans la console. Appuyer sur la touche "r" redemarre le jeu.
Bon jeu! :)
"""

import EZ
import pygame
import random

tab_game = [[0,0,0],
            [0,0,0],
            [0,0,0]
]
"""
Ici tab_game est une variable globale car cest le seul tableau avec lequel les fonctions interragissent, cela evite a toujours avoir a mettre tab_game en tant que parametres dans les fonctions
"""

#Constantes
LARGEUR = 600
HAUTEUR = LARGEUR
SEPARATION = 5
DEFAULT_PLAYER = 1
AUDIO = True
#La constante audio est iniquement la pour pouvoir rapidement desactive laudio sil y a un probleme de compatibilite entre pygame et la passerelle audio (par exemple les conflits entre PipeWire et PulseAudio sous Linux)
NOIR = (0,0,0)
BLANC = (255,255,255)
GRIS = (150,150,150)
GRIS_FONCE = (92,92,92)
BRUN = (189,154,122)
BLEU_DISK = (1,87,155)
COULEUR_FOND = (232,217,190)
JAUNE = (255,240,0)
VERT = (50,205,50)
BLEU = (100,149,237)
ROUGE = (255,51,51)
VIOLET = (153,50,204)
ROSE = (255,105,180)

def menu(c1 = BLEU, c2 = ROUGE):
    """
    Fonction qui creer la fenetre et affiche le menu principal
    Elle soccupe egalement de linteraction avec les differents bouttons du menu principal
    c1 et c2 servent a conserver la couleurs des joueurs lors du redemarrage dun partie
    """
    EZ.creation_fenetre(LARGEUR, HAUTEUR, "Tic Tac Toe par Romain Schneider")
    if AUDIO == True:
        JVSJ = EZ.charge_son("JVSJ.ogg")
        VSIA = EZ.charge_son("VSIA.ogg")
        global ROND
        ROND = EZ.charge_son("CRAYON.ogg")
        global CROSS
        CROSS = EZ.charge_son("CROSS.ogg")
        global PWIN
        PWIN = EZ.charge_son("PWIN.ogg")
        global IAWIN
        IAWIN = EZ.charge_son("IAWIN.ogg")
        global EXEKO
        EXEKO = EZ.charge_son("EXEKO.ogg")
    global hard
    hard = False
    global COULEUR_J1
    COULEUR_J1 = c1
    global COULEUR_J2
    COULEUR_J2 = c2
    init_menu()
    EZ.mise_a_jour()
    while True:
        event = EZ.recupere_evenement()
        if event == 'EXIT':
            kill()
        elif(event == "SOURIS_BOUTON_GAUCHE_ENFONCE"):
            x_souris, y_souris = EZ.coordonnees_souris()
            """
            Les trois "if" suivants detectent si le joueur clique sur un des trois boutons pour jouer
            """
            if(x_souris in range(LARGEUR//12+1, LARGEUR//12+200+1)) and (y_souris in range(HAUTEUR//2+1, HAUTEUR//2+50+1)):
                if AUDIO == True:
                    EZ.joue_son(JVSJ)
                game()
            if(x_souris in range(7*LARGEUR//12+1, 7*LARGEUR//12+200+1)) and (y_souris in range(HAUTEUR//2-25-10+1, HAUTEUR//2-25-10+50+1)):
                if AUDIO == True:
                    EZ.joue_son(VSIA)
                print('jeu contre ia facile')
                game(1)
            if(x_souris in range(7*LARGEUR//12+1, 7*LARGEUR//12+200+1)) and (y_souris in range(HAUTEUR//2+25+10+1, HAUTEUR//2+25+10+50+1)):
                if AUDIO == True:
                    EZ.joue_son(VSIA)
                print('jeu contre ia difficile')
                game(2)
            """
            Les "if" suivants detectent si le joueur 1 (croix) change de couleur et changent la couleur du joueur
            """
            if(x_souris in range(LARGEUR//12+1, LARGEUR//12+40+1)) and (y_souris in range(HAUTEUR//2+150+1, HAUTEUR//2+150+40+1)):
                COULEUR_J1 = JAUNE
                choix_couleur(1,0)
            if(x_souris in range(LARGEUR//12+80+1, LARGEUR//12+80+40+1)) and (y_souris in range(HAUTEUR//2+150+1, HAUTEUR//2+150+40+1)):
                COULEUR_J1 = VERT
                choix_couleur(1,1)
            if(x_souris in range(LARGEUR//12+2*80+1, LARGEUR//12+2*80+40+1)) and (y_souris in range(HAUTEUR//2+150+1, HAUTEUR//2+150+40+1)):
                COULEUR_J1 = BLEU
                choix_couleur(1,2)
            if(x_souris in range(LARGEUR//12+1, LARGEUR//12+40+1)) and (y_souris in range(HAUTEUR//2+150+40+20+1, HAUTEUR//2+150+40+20+40+1)):
                COULEUR_J1 = ROUGE
                choix_couleur(1,3)
            if(x_souris in range(LARGEUR//12+80+1, LARGEUR//12+80+40+1)) and (y_souris in range(HAUTEUR//2+150+40+20+1, HAUTEUR//2+150+40+20+40+1)):
                COULEUR_J1 = VIOLET
                choix_couleur(1,4)
            if(x_souris in range(LARGEUR//12+2*80+1, LARGEUR//12+2*80+40+1)) and (y_souris in range(HAUTEUR//2+150+40+20+1, HAUTEUR//2+150+40+20+40+1)):
                COULEUR_J1 = ROSE
                choix_couleur(1,5)
            """
            Les "if" suivants detectent si le joueur 2 (cercle) change de couleur et changent la couleur du joueur
            """
            if(x_souris in range(7*LARGEUR//12+1, 7*LARGEUR//12+40+1)) and (y_souris in range(HAUTEUR//2+150+1, HAUTEUR//2+150+40+1)):
                COULEUR_J2 = JAUNE
                choix_couleur(2,0)
            if(x_souris in range(7*LARGEUR//12+80+1, 7*LARGEUR//12+80+40+1)) and (y_souris in range(HAUTEUR//2+150+1, HAUTEUR//2+150+40+1)):
                COULEUR_J2 = VERT
                choix_couleur(2,1)
            if(x_souris in range(7*LARGEUR//12+2*80+1, 7*LARGEUR//12+2*80+40+1)) and (y_souris in range(HAUTEUR//2+150+1, HAUTEUR//2+150+40+1)):
                COULEUR_J2 = BLEU
                choix_couleur(2,2)
            if(x_souris in range(7*LARGEUR//12+1, 7*LARGEUR//12+40+1)) and (y_souris in range(HAUTEUR//2+150+40+20+1, HAUTEUR//2+150+40+20+40+1)):
                COULEUR_J2 = ROUGE
                choix_couleur(2,3)
            if(x_souris in range(7*LARGEUR//12+80+1, 7*LARGEUR//12+80+40+1)) and (y_souris in range(HAUTEUR//2+150+40+20+1, HAUTEUR//2+150+40+20+40+1)):
                COULEUR_J2 = VIOLET
                choix_couleur(2,4)
            if(x_souris in range(7*LARGEUR//12+2*80+1, 7*LARGEUR//12+2*80+40+1)) and (y_souris in range(HAUTEUR//2+150+40+20+1, HAUTEUR//2+150+40+20+40+1)):
                COULEUR_J2 = ROSE
                choix_couleur(2,5)
        elif(event == "TOUCHE_ENFONCEE"):
            if EZ.touche() == 'r':
                restart()

def game(ia = False):
    """
    Fonction principal du jeu, elle gere le deroulement de la partie (jouer chacun sons tour, detecter si un joueur gagne etc...)
    """
    print('Couleur du joueur 1 (croix) : '+str(COULEUR_J1))
    print('Couleur du joueur 2 (cercle) : '+str(COULEUR_J2))
    global round_nbr
    round_nbr = 0
    END = False
    init_room()
    player = DEFAULT_PLAYER
    while END == False:
        EZ.mise_a_jour()
        while True:
            event = EZ.recupere_evenement()
            if event == 'EXIT':
                kill()
            elif(event == "SOURIS_BOUTON_GAUCHE_ENFONCE") or (player == 2 and ia != False):
                break
            elif(event == "TOUCHE_ENFONCEE"):
                if EZ.touche() == 'r':
                    restart()
        if player == 1:
            round(1)
            player = 2
        else:
            if ia == False:
                round(2)
                player = 1
            else:
                ia_round(ia)
                player = 1
        if test_victoire() == 1:
            player_win(1, ia)
        if(test_victoire() == 2):
            player_win(2, ia)
        if(test_victoire() == -1):
            END = True
        print('tour suivant. round : '+str(round_nbr))
    print('Partie termine sans victoire')
    player_win()
    print("erreur: boucle principale quittee")
    kill()

def player_win(player = None, ia = False):
    """
    Fonction qui dessine le menu de fin (avec si necessaire les details de la victoire)
    Elle dessine egalement les bouttons et gere linteraction de ces boutons (exporter la partie en image ou redemarrer le jeu)
    """
    print('jeu termine avec succes')
    snapshot = EZ.sauvegarde_fenetre()
    if AUDIO == True:
        if((player == 1) or (player == 2 and ia == False)):
            EZ.joue_son(PWIN)
        elif((player == 2) and (ia != False)):
            EZ.joue_son(IAWIN)
        elif(player == None):
            EZ.joue_son(EXEKO)
    saved = False
    """
    La boucle suivante sert pour le fondu
    """
    for i in range(0, 10):
        temps_debut= EZ.clock()
        while EZ.clock() - temps_debut < 0.1:
            EZ.trace_rectangle_droit(0, 0, LARGEUR, HAUTEUR, 240, 248, 255, i)
            EZ.mise_a_jour()
    myfont = pygame.font.SysFont("arial.ttf",50)
    debut = EZ.clock()
    texte_nbr_tour = EZ.image_texte("Partie finie en "+str(round_nbr)+" tours", myfont, *GRIS)
    l_txt, h_txt = EZ.dimension(texte_nbr_tour)
    EZ.trace_image(texte_nbr_tour, LARGEUR//2-l_txt//2, HAUTEUR//2-h_txt//2-50)
    EZ.trace_rectangle_droit(120, HAUTEUR//2+60, 100, 100, *BRUN)
    EZ.trace_rectangle_droit(LARGEUR//2+75, HAUTEUR//2+60, 100, 100, *BRUN)
    disk(130,HAUTEUR//2+70,BLEU_DISK)
    domo(LARGEUR//2+85,HAUTEUR//2+70)
    encadre_bouton(120, HAUTEUR//2+60, 100, 100)
    encadre_bouton(LARGEUR//2+75, HAUTEUR//2+60, 100, 100)
    """
    Cette derniere boucle gere le reste (texte, boutons, interactions)
    """
    while True:
        if EZ.clock() - debut > 0.1:
            if player == None:
                texte_victoire = EZ.image_texte("AUCUN GAGNANT", myfont, *NOIR)
            elif(ia == False):
                texte_victoire = EZ.image_texte("VICTOIRE DU JOUEUR "+str(player)+" !", myfont, random.randrange(0,256), random.randrange(0,256), random.randrange(0,256))
            else:
                if(player == 1):
                    texte_victoire = EZ.image_texte("VICTOIRE DU JOUEUR !", myfont, random.randrange(0,256), random.randrange(0,256), random.randrange(0,256))
                else:
                    texte_victoire = EZ.image_texte("VICTOIRE DE L'IA !", myfont, random.randrange(0,256), random.randrange(0,256), random.randrange(0,256))
            l_txt, h_txt = EZ.dimension(texte_victoire)
            EZ.trace_image(texte_victoire, LARGEUR//2-l_txt//2, HAUTEUR//2-h_txt//2-150)
            EZ.mise_a_jour()
            debut = EZ.clock()
        event = EZ.recupere_evenement()
        if event == 'EXIT':
            kill()
        elif(event == "SOURIS_BOUTON_GAUCHE_ENFONCE"):
            x_souris, y_souris = EZ.coordonnees_souris()
            if(x_souris in range(121,221) and y_souris in range(HAUTEUR//2+60+1,HAUTEUR//2+160+1) and saved == False):
                EZ.sauvegarde_image(snapshot,'TicTacToe-'+str(tab_game)+'.png')
                disk(130,HAUTEUR//2+70,GRIS_FONCE)
                saved = True
                print('sauveagrder')
            elif(x_souris in range(LARGEUR//2+75+1,LARGEUR//2+175+1) and y_souris in range(HAUTEUR//2+60+1,HAUTEUR//2+160+1)):
                restart()
        elif(event == "TOUCHE_ENFONCEE"):
            if EZ.touche() == 'r':
                restart()
    print('erreur : boucle quittee')
    kill()

def test_victoire():
    """
    Fonction qui verifie si un des joueurs a gagne et retourne le joueur en question, elle retourne -1 si la partie se termine (toutes les cases sont remplies) sans gagnant et retourne 0 si la partie nest pas rempli et quil ny a pas de gagnant
    Elle utilise les fonctions win_h(), win_v(), win_z() et test_complet() pour retourner le bon resultat
    """
    if (win_h() or win_v() or win_z()) == 1:
        print('J1 Gagne!')
        return 1
    elif((win_h() or win_v() or win_z()) == 2):
        print('J2 gagne!')
        return 2
    elif(test_complet() == True):
        print('partie remplie')
        return -1
    return 0

def win_h():
    """
    Fonction qui verifie si un joueur a rempli 3 cases horizontalement
    """
    for i in range(3):
        if tab_game[i][0] == tab_game[i][1] == tab_game[i][2] == 1:
            return 1
        elif(tab_game[i][0] == tab_game[i][1] == tab_game[i][2] == 2):
            return 2
    return 0

def win_v():
    """
    Fonction qui verifie si un joueur a rempli 3 cases verticalement
    """
    for i in range(3):
        if tab_game[0][i] == tab_game[1][i] == tab_game[2][i] == 1:
            return 1
        elif(tab_game[0][i] == tab_game[1][i] == tab_game[2][i] == 2):
            return 2
    return 0

def win_z():
    """
    Fonction qui verifie si un joueur a rempli une des deux diagonales
    """
    if (tab_game[0][0] == tab_game[1][1] == tab_game[2][2] == 1) or (tab_game[0][2] == tab_game[1][1] == tab_game[2][0] == 1):
        return 1
    elif((tab_game[0][0] == tab_game[1][1] == tab_game[2][2] == 2) or (tab_game[0][2] == tab_game[1][1] == tab_game[2][0] == 2)):
        return 2
    return 0

def test_complet():
    """
    Fonction qui verifie si le jeu est complet
    Il aurait aussi ete possible de verifier le nombre de round
    """
    for i in range(3):
        for j in range(3):
            if tab_game[j][i] == 0:
                return False
    return True

def f_test_test_victoire():
    """
    Fonction de test de la fonction test_victoire(), donc elle teste egalement les 5 fonctions precedentes
    """
    f_test_init([[1,1,1],[0,0,0],[2,0,2]])
    assert test_victoire() == 1
    f_test_init([[2,1,2],[2,1,2],[1,2,1]])
    assert test_victoire() == -1
    f_test_init([[1,2,0],[0,0,0],[0,1,0]])
    assert test_victoire() == 0
    f_test_init([[2,1,1],[0,2,1],[1,0,2]])
    assert test_victoire() == 2
    reset_tab()



def init_room():
    """
    Fonction qui soccupe de lanimation de transition puis qui dessine lespace de jeu
    """
    for i in range(0,LARGEUR+1,5):
        debut = EZ.clock()
        while EZ.clock() - debut < 0.005:
            for g in range(0,HAUTEUR,HAUTEUR//20*2):
                EZ.trace_rectangle_droit(0, g, i, HAUTEUR//20, *COULEUR_FOND)
            for d in range(HAUTEUR-HAUTEUR//20,0,-HAUTEUR//20*2):
                EZ.trace_rectangle_droit(LARGEUR-i, d, i, HAUTEUR//20, *COULEUR_FOND)
            EZ.mise_a_jour()

    for i in range(601):
        debut = EZ.clock()
        while EZ.clock() - debut < 0.0005:
            for j in range(2):
                EZ.trace_rectangle_droit(LARGEUR//3-SEPARATION+j*(LARGEUR//3), 0, SEPARATION, i, *GRIS_FONCE)
            for j in range(2):
                EZ.trace_rectangle_droit(0, HAUTEUR//3-SEPARATION+j*(HAUTEUR//3), i, SEPARATION, *GRIS_FONCE)
            EZ.mise_a_jour()

def init_menu():
    """
    Fonction qui trace les elements graphiques du menu principal (titre, boutons, etc)
    """
    myfont = pygame.font.SysFont("arial.ttf",75)
    texte_titre1 = EZ.image_texte("T  I  C", myfont, *BRUN)
    l_txt, h_txt = EZ.dimension(texte_titre1)
    EZ.trace_image(texte_titre1, LARGEUR//2-l_txt//2, HAUTEUR//4-h_txt-20)
    EZ.trace_rectangle_droit(LARGEUR//2-l_txt//1.5, HAUTEUR//4-h_txt+30, l_txt+l_txt//1.5//2, SEPARATION, *GRIS_FONCE)
    texte_titre2 = EZ.image_texte("T A C", myfont, *BRUN)
    EZ.trace_image(texte_titre2, LARGEUR//2-l_txt//2+1, HAUTEUR//4-h_txt-20+h_txt+8)
    EZ.trace_rectangle_droit(LARGEUR//2-l_txt//1.5, HAUTEUR//4-h_txt+h_txt+10+30, l_txt+l_txt//1.5//2, SEPARATION, *GRIS_FONCE)
    texte_titre3 = EZ.image_texte("T O E", myfont, *BRUN)
    EZ.trace_image(texte_titre3, LARGEUR//2-l_txt//2, HAUTEUR//4-h_txt-20+2*h_txt+20)
    EZ.trace_rectangle_droit(LARGEUR//2-l_txt//4,HAUTEUR//4-h_txt-30, SEPARATION, l_txt+l_txt//1.5//2, *GRIS_FONCE)
    EZ.trace_rectangle_droit(LARGEUR//2+l_txt//6.5,HAUTEUR//4-h_txt-30, SEPARATION, l_txt+l_txt//1.5//2, *GRIS_FONCE)

    myfont = pygame.font.SysFont("arial.ttf",25)
    texte_jvsj = EZ.image_texte("JOUEUR VS JOUEUR", myfont, *NOIR)
    l_txt, h_txt = EZ.dimension(texte_jvsj)
    EZ.trace_rectangle_droit(LARGEUR//12, HAUTEUR//2,200,50, *GRIS)
    EZ.trace_image(texte_jvsj, LARGEUR//12+100-l_txt//2, HAUTEUR//2+25-h_txt//2)
    encadre_bouton(LARGEUR//12, HAUTEUR//2,200,50)
    texte_jvsia = EZ.image_texte("JOUEUR VS IA", myfont, *NOIR)
    l_txt, h_txt = EZ.dimension(texte_jvsia)
    EZ.trace_rectangle_droit(7*HAUTEUR//12, HAUTEUR//2-25-10,200,50, *VERT)
    EZ.trace_image(texte_jvsia, 7*LARGEUR//12+100-l_txt//2, HAUTEUR//2+25-h_txt//2-25-10)
    encadre_bouton(7*HAUTEUR//12, HAUTEUR//2-25-10,200,50)
    texte_jvsia = EZ.image_texte("JOUEUR VS IA", myfont, *NOIR)
    l_txt, h_txt = EZ.dimension(texte_jvsia)
    EZ.trace_rectangle_droit(7*HAUTEUR//12, HAUTEUR//2+25+10,200,50, *ROUGE)
    EZ.trace_image(texte_jvsia, 7*LARGEUR//12+100-l_txt//2, HAUTEUR//2+25-h_txt//2+25+10)
    encadre_bouton(7*HAUTEUR//12, HAUTEUR//2+25+10,200,50)
    texte_couleurj1 = EZ.image_texte("Couleur J1 (croix)", myfont, *BLEU)
    l_txt, h_txt = EZ.dimension(texte_couleurj1)
    EZ.trace_image(texte_couleurj1, LARGEUR//12+100-l_txt//2, HAUTEUR//2+100-h_txt//2)
    texte_couleurj2 = EZ.image_texte("Couleur J2/IA (cercle)", myfont, *ROUGE)
    l_txt, h_txt = EZ.dimension(texte_couleurj2)
    EZ.trace_image(texte_couleurj2, 7*LARGEUR//12+100-l_txt//2, HAUTEUR//2+100-h_txt//2)

    """
    Les if et elif suivants encardent la couleur au demarrage du jeu
    """
    if(COULEUR_J1 == JAUNE):
        choix_couleur(1,0)
    elif(COULEUR_J1 == VERT):
        choix_couleur(1,1)
    elif(COULEUR_J1 == BLEU):
        choix_couleur(1,2)
    elif(COULEUR_J1 == ROUGE):
        choix_couleur(1,3)
    elif(COULEUR_J1 == VIOLET):
        choix_couleur(1,4)
    elif(COULEUR_J1 == ROSE):
        choix_couleur(1,5)

    if(COULEUR_J2 == JAUNE):
        choix_couleur(2,0)
    elif(COULEUR_J2 == VERT):
        choix_couleur(2,1)
    elif(COULEUR_J2 == BLEU):
        choix_couleur(2,2)
    elif(COULEUR_J2 == ROUGE):
        choix_couleur(2,3)
    elif(COULEUR_J2 == VIOLET):
        choix_couleur(2,4)
    elif(COULEUR_J2 == ROSE):
        choix_couleur(2,5)

def init_menu_couleur(x,y):
    """
    Dessine des rectangle de couleurs
    """
    EZ.trace_rectangle_droit(x,y+150,40,40, *JAUNE)
    EZ.trace_rectangle_droit(x+80,y+150,40,40, *VERT)
    EZ.trace_rectangle_droit(x+2*80,y+150,40,40, *BLEU)
    EZ.trace_rectangle_droit(x,y+150+40+20,40,40, *ROUGE)
    EZ.trace_rectangle_droit(x+80,y+150+40+20,40,40, *VIOLET)
    EZ.trace_rectangle_droit(x+2*80,y+150+40+20,40,40, *ROSE)

def choix_couleur(player, couleur):
    """
    Encadre la couleur choisie par le joueur
    Le code couleur est le suivant : 0 = jaune, 1 = vert, 2 = bleu, 3 = rouge, 4 = violet et 5 = rose (dans le menu de gauche a droite puis de bas en haut)
    """
    if player == 1:
        init_menu_couleur(LARGEUR//12,HAUTEUR//2)
    else:
        init_menu_couleur(7*LARGEUR//12,HAUTEUR//2)
    if couleur in (0,1,2):
        encadre_bouton(LARGEUR//12+couleur*80+(player-1)*6*LARGEUR//12,HAUTEUR//2+150)
    else:
        encadre_bouton(LARGEUR//12+(couleur-3)*80+(player-1)*6*LARGEUR//12,HAUTEUR//2+150+20+40)
    EZ.mise_a_jour()

def encadre_bouton(x,y,l = 40,h = 40):
    """
    Fonction qui dessine le contour noir pour encadrer les bouttons
    """
    EZ.trace_rectangle_droit(x,y,l,5, *NOIR)
    EZ.trace_rectangle_droit(x+l-5,y,5,h, *NOIR)
    EZ.trace_rectangle_droit(x,y+h-5,l,5, *NOIR)
    EZ.trace_rectangle_droit(x,y,5,h-5, *NOIR)



def round(player):
    """
    Fonction qui gere le deroulement dun tour dune partie entre deux joueurs : elle recupere la position ou le joueur choisi de jouer et incremente de 1 le nombre total de tours joues (1 tour = 1 mouvement de CHAQUE joueur)
    """
    coo = EZ.coordonnees_souris()
    coo_mat = [-1,-1]
    if coo[0] in range(0, LARGEUR//3-SEPARATION):
        coo_mat[0] = 0
    elif(coo[0] in range(LARGEUR//3, LARGEUR//3-SEPARATION+LARGEUR//3)):
        coo_mat[0] = 1
    elif(coo[0] in range((LARGEUR//3)*2, LARGEUR)):
        coo_mat[0] = 2

    if coo[1] in range(0, HAUTEUR//3-SEPARATION):
        coo_mat[1] = 0
    elif(coo[1] in range(HAUTEUR//3, HAUTEUR//3-SEPARATION+HAUTEUR//3)):
        coo_mat[1] = 1
    elif(coo[1] in range((HAUTEUR//3)*2, HAUTEUR)):
        coo_mat[1] = 2

    if (coo_mat[0] != -1 and coo_mat[1] != -1) and (tab_game[coo_mat[1]][coo_mat[0]] != 1 and tab_game[coo_mat[1]][coo_mat[0]] != 2):
        """
        Si le joueur clique sur une case et qu elle est vide alors son coup est valide
        """
        if(player == 1):
            global round_nbr
            round_nbr += 1
        trace_forme(player, *coo_mat)
    else:
        """
        Si le joueur clique sur un separation ou sur une case deja remplie cest a nouveau son tour (il na rien place)
        """
        EZ.attendre_action()
        round(player)



def ia_round(difficulty):
    """
    Fonction qui fait jouer lordinateur contre le joueur
    """
    """
    Dabord elle verifie si elle peut gagner et joue en consequence
    """
    victory = can_player_win(2)
    print('vicoire ia : '+str(victory))
    """
    Si elle ne peut pas gagner elle verifie que le joueur ne peut pas gagner et joue en consequence (bloque le joueur ou joue simplement)
    """
    if victory == -1:
        danger = can_player_win(1)
        if danger == -1:
            print('ordi attaque...')
            ia_attack(difficulty)
        else:
            print('ordi defend...')
            trace_forme(2,*danger)
    else:
        trace_forme(2,*victory)

def ia_attack(difficulty):
    """
    Joue a une case aleatoire, si possible pertinante, cest a dire qui permet de gagner au prochain tour
    Lordi a un comportement particulier si cest son premier tour (il prend le milieu si disponible, sinon il prend un coin), sinon il joue normalement
    """
    if difficulty == 2:
        if round_nbr == 1:
            if(tab_game[1][1] == 0):
                trace_forme(2,1,1)
            elif(tab_game[1][1] == 1):
                trace_forme(2,random.choice([0,2]),random.choice([0,2]))
        elif(round_nbr == 2):
            """
            Ce elif soccupe de plusieurs cas particuliers ou le joueur peut gagner de deux facons differentes au tour 3, donc bloquer le joueur au tour suivant ne suffit pas car il a une deuxieme option pour gagner. Ces deux cas particuliers sont detectes grace a ce elif et lordi empeche alors le joueur dutiliser de telles strategies
            """
            if((tab_game[0][2] == 1) and (tab_game[1][1] == 2) and (tab_game[2][0] == 1)):
                trace_forme(2,random.choice([0,2]), 1)
            elif((tab_game[0][0] == 2) and (tab_game[1][1] == 1) and (tab_game[2][2] == 1)):
                coo = random.choice([(0,2),(2,0)])
                trace_forme(2,*coo)
            elif((tab_game[1][1] == 2) and (tab_game[2][1] == 1) and (tab_game[1][2] == 1)):
                trace_forme(2,2,2)
            elif((tab_game[1][1] == 2) and (tab_game[0][0] == 1) and (tab_game[2][1] == 1)):
                trace_forme(2,0,2)
            elif((tab_game[1][1] == 2) and (tab_game[0][2] == 1) and (tab_game[2][1] == 1)):
                trace_forme(2,2,2)
            elif((tab_game[1][1] == 2) and (tab_game[1][2] == 1) and (tab_game[2][0] == 1)):
                trace_forme(2,2,2)
            else:
                ia_complete()
        elif(round_nbr == 3):
            """
            Ce elif gere les cas particuliers du tour 3
            """
            if((tab_game[0][1] and tab_game[1][1] == 2) and (tab_game[0][0] and tab_game[1][2] and tab_game[2][1] == 1)):
                trace_forme(2,0,2)
            else:
                ia_complete()
        else:
                ia_complete()
    else:
        ia_complete()

def ia_complete():
    """
    Determine ou lordi doit jouer sil ne peut pas gagner au tour actuel (il essaie de faire le coup le plus pertinant cest a dire qui peut le faire gagner au prochain tour)
    """
    global tab_game
    print('ordi complete tab :'+str(tab_game))
    for i in range(3):
        for j in range(3):
            if tab_game[i][j] == 0:
                """
                Ici lordi simule le scenario pour determiner si il lui permet de gagner au prochain tour et si possible joue ce scenario pertinant sinon il joue aleatoirement (car dans ce cas ni lui ni le joueur ne peut gagner)
                """
                tab_sauv = [[0,0,0],[0,0,0],[0,0,0]]
                for a in range(0,3):
                    for b in range(0,3):
                        tab_sauv[a][b] = tab_game[a][b]
                #print('tab game :'+str(tab_game)+'/tab sauv :'+str(tab_sauv))
                tab_game[i][j] = 2
                #print('tab game simule '+str(tab_game))
                pertinance = can_player_win(2)
                tab_game = tab_sauv
                #print('tab_game restore '+str(tab_game))
                if pertinance != -1:
                    print('coup pertinant disponible')
                    trace_forme(2,j,i)
                    return
                    """
                    Il faut arreter la fonction sinon lordi se permet de rejouer immediatement apres avoir joue son coup pertinant :O
                    """
    while True:
        x_p = random.randrange(0,3)
        y_p = random.randrange(0,3)
        if tab_game[y_p][x_p] == 0:
            print('aucun coup pertinant dispo')
            trace_forme(2,x_p,y_p)
            break



def can_player_win(p):
    """
    Retourne la position de la case à jouer pour bloquer le joueur s'il est suceptible de gagner au prochain tour sinon elle retourne -1 (=pas de risque de perdre au prochain tour)
    Elle retourne les coordonnees dans le format (x,y) car cest celui utiliser par la fonction trace_forme()
    """
    """
    La premiere boucle verifie si le joueur peut gagner horizontalement
    """
    #p = 1
    for i in range(0,3):
        if((tab_game[i] == [p,0,p]) or (tab_game[i] == [p,p,0]) or (tab_game[i] == [0,p,p])):
            for j in range(0,3):
                if(tab_game[i][j]) == 0:
                    print("joueur "+str(p)+" peut gagner horizontalement en "+str((j,i)))
                    return (j,i)

    """
    La deuxieme boucle verifie si le joueur peut gagner verticalement
    """
    for i in range(0,3):
        if(((tab_game[0][i] == p) and (tab_game[2][i] == p) and (tab_game[1][i] == 0)) or ((tab_game[0][i] == p) and (tab_game[1][i] == p) and (tab_game[2][i] == 0)) or ((tab_game[1][i] == p) and (tab_game[2][i] == p) and (tab_game[0][i] == 0))):
            for j in range(0,3):
                if(tab_game[j][i]) == 0:
                    print("joueur "+str(p)+" peut gagner verticalement en "+str((i,j)))
                    return (i,j)

    """
    Les deux verifications suivantes verifie si le joueur peut gagner sur une des deux diagonales
    """
    if(((tab_game[0][0] == p) and (tab_game[2][2] == p) and (tab_game[1][1] == 0)) or ((tab_game[0][0] == p) and (tab_game[1][1] == p) and (tab_game[2][2] == 0)) or ((tab_game[1][1] == p) and (tab_game[2][2] == p) and (tab_game[0][0] == 0))):
        for i in range(0,3):
            if(tab_game[i][i]) == 0:
                print("joueur "+str(p)+" peut gagner diago descendante en "+str((i,i)))
                return (i,i)
    if(((tab_game[0][2] == p) and (tab_game[2][0] == p) and (tab_game[1][1] == 0)) or ((tab_game[0][2] == p) and (tab_game[1][1] == p) and (tab_game[2][0] == 0)) or ((tab_game[1][1] == p) and (tab_game[2][0] == p) and (tab_game[0][2] == 0))):
        for i in range(0,3):
            if(tab_game[i][2-i]) == 0:
                print("joueur "+str(p)+" peut gagner diago montante en "+str((2-i,i)))
                return (2-i,i)
    return -1

def f_test_can_player_win():
    """
    Fonction de test de la fonction can_player_win()
    """
    f_test_init([[1,0,0],[0,0,1],[0,0,1]])
    assert can_player_win(1) == (2,0)
    assert can_player_win(2) == -1
    f_test_init([[2,1,1],[1,2,0],[0,0,0]])
    assert can_player_win(2) == (2,2)
    assert can_player_win(1) == -1
    f_test_init([[1,2,0],[2,0,1],[0,1,0]])
    assert can_player_win(1) == -1
    assert can_player_win(2) == -1
    reset_tab()



def trace_forme(type, mat_x, mat_y):
    """
    Fonction qui trace la croix ou le cerlce aux coordonnees indiquees et note ce trace dans la matrice
    """
    if type == 1:
        if AUDIO == True:
            EZ.joue_son(CROSS)
        tab_game[mat_y][mat_x] = 1
        print(tab_game)
        croix(LARGEUR//3+mat_x*(LARGEUR//3)-(LARGEUR//3)//2-SEPARATION, HAUTEUR//3+mat_y*(HAUTEUR//3)-(LARGEUR//3)//2-SEPARATION)
    elif(type == 2):
        if AUDIO == True:
            EZ.joue_son(ROND)
        tab_game[mat_y][mat_x] = 2
        print(tab_game)
        cercle(LARGEUR//3+mat_x*(LARGEUR//3)-(LARGEUR//3)//2-SEPARATION, HAUTEUR//3+mat_y*(HAUTEUR//3)-(LARGEUR//3)//2-SEPARATION)

def croix(x,y,chrono = 0.03):
    """
    Trace une croix (avec animation) aux coordonnees donnees
    """
    x -= 50
    y -= 50
    for i in range(40):
        debut = EZ.clock()
        while EZ.clock() - debut < chrono:
            EZ.trace_rectangle_droit(x+40-i+1, y+40-i+1, 0+20+2*i, 0+20+2*i, *COULEUR_J1)
            EZ.trace_triangle(x+10, y, x+90, y, x+50, y+40, *COULEUR_FOND)
            EZ.trace_triangle(x+100, y+10, x+100, y+90, x+60, y+50, *COULEUR_FOND)
            EZ.trace_triangle(x+90, y+100, x+10, y+100, x+50, y+60, *COULEUR_FOND)
            EZ.trace_triangle(x, y+90, x, y+10, x+40, y+50, *COULEUR_FOND)
            EZ.mise_a_jour()

def cercle(x,y,chrono = 0.07):
    """
    Trace un cercle (avec animation) aux coordonnees donnees
    """
    for i in range(10):
        debut = EZ.clock()
        while EZ.clock() - debut < chrono:
            EZ.trace_disque(x,y,40+i, *COULEUR_J2)
            EZ.trace_disque(x,y,40,*COULEUR_FOND)
            EZ.mise_a_jour()

def disk(x,y,couleur):
    """
    Fonction qui dessine la disquette du menu de fin
    """
    EZ.trace_rectangle_droit(x,y,80,80,*couleur)
    EZ.trace_triangle(x+70,y,x+80,y,x+80,y+10, *BRUN)
    EZ.trace_rectangle_droit(x+10, y+45, 60, 30, *BLANC)
    EZ.trace_rectangle_droit(x+15,y+5, 50 , 25, *BLANC)
    EZ.trace_rectangle_droit(x+50,y+10, 10, 15, *couleur)

def domo(x,y):
    """
    Fcontion qui dessine la maison du menu de fin
    """
    EZ.trace_rectangle_droit(x+10,y+40,60,40,*BLEU_DISK)
    EZ.trace_triangle(x,y+40,x+40,y,x+80,y+40, *BLEU_DISK)
    EZ.trace_rectangle_droit(x+55, y, 15, 40, *BLEU_DISK)
    EZ.trace_rectangle_droit(x+34,y+60, 15 , 20, *BLANC)

def restart():
    """
    Redmarre le jeu (et reintilaise la matrice, meme si ce nest pas vraiment necessaire de le faire ici) et fait persister les couleurs dune partie a lautre
    """
    reset_tab()
    EZ.destruction_fenetre()
    print('Game will restart shortly')
    menu(COULEUR_J1, COULEUR_J2)

def multi_test():
    """
    Fonction qui lance toutes les fonctions de test
    """
    print('Demarrage des tests...')
    f_test_test_victoire()
    f_test_can_player_win()
    print('Tous les test sont reussis!')

def f_test_init(tab):
    """
    Les fonctions utilisent toujours tab_game car cest le seul tableau a manipuler pour le jeu
    Cette fonction modifie simplement tab_game pour les fonctions de tests
    """
    global tab_game
    tab_game = tab

def reset_tab():
    """
    Reinitialise la matrice
    """
    for i in range(3):
        for j in range(3):
            tab_game[j][i] = 0

def kill():
    """
    Ferme le jeu et reinitialise la matrice (meme si ce n'est pas vraiment necessaire)
    """
    reset_tab()
    print('Game killed successfully')
    EZ.destruction_fenetre()
    exit()

menu()